--DSplayer Edited 2025-03-21
local function deepcopy(orig)
    local orig_type = type(orig)
    local copy
    if orig_type == 'table' then
        copy = {}
        for orig_key, orig_value in pairs(orig) do
            copy[deepcopy(orig_key)] = deepcopy(orig_value)
        end
    else -- number, string, boolean, etc
        copy = orig
    end
    return copy
end

AGM_45A =
{
	category			= CAT_MISSILES,
	name				= "AGM_45A",
	user_name			= _("AGM-45A Shrike ARM"),
	display_name_short	= "AGM-45A",
	scheme				= "agm_45",
	class_name			= "wAmmunitionSelfHoming",
	model				= "HB_F-4E_EXT_AGM45",
	mass				= 180,

	wsTypeOfWeapon		= {wsType_Weapon, wsType_Missile, wsType_AS_Missile, AGM_45},

	Escort				= 0,
	Head_Type			= 3,
	sigma				= {0, 0, 0},
	M					= 180,
	H_max				= 24400,
	H_min				= 600,		--with the exception of G-bias vairant, missile is nearly guaranteed to fail to track when launched below this altitude, both in Loft and Direct mode (although for different reasons)
	Diam				= 203,
	Cx_pil				= 6.9,		--2.3 * 3
	D_max				= 30000,
	D_min				= 1500,
	Head_Form			= 1,
	Life_Time			= 300,
	Nr_max				= 3,
	v_min				= 170,
	v_mid				= 500,
	Mach_max			= 2,
	t_b					= 0,
	t_acc				= 2.8,
	t_marsh				= 0,
	Range_max			= 30000,
	H_min_t				= 600,
	Fi_start			= 0.5,
	Fi_rak				= 3.14152,
	Fi_excort			= 1,
	Fi_search			= 99.9,
	OmViz_max			= 99.9,
	X_back				= 0,
	Y_back				= 0,
	Z_back				= 0,
	Reflection			= 0.08,
	KillDistance		= 10,
	loft				= 1,
	loft_factor			= 3,
	ballistic_loft		= true,

	SeekerGen = 1,  -- Seeker generation

	manualWeaponFlag = 1,

	--MinLaunchDistData =
	--{
	--	24,		10,
	--
	--			100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
	--	100,	1500,	1700,	1900,	2050,	2250,	2400,	2550,	2750,	2900,	3050,	
	--	200,	2050,	2250,	2450,	2600,	2800,	3000,	3150,	3300,	3500,	3650,	
	--	300,	2400,	2600,	2850,	3000,	3200,	3400,	3550,	3750,	3900,	4100,	
	--	400,	2650,	2900,	3100,	3300,	3500,	3700,	3900,	4050,	4250,	4400,	
	--	500,	2900,	3150,	3350,	3550,	3750,	3950,	4150,	4350,	4550,	4700,	
	--	600,	3100,	3350,	3600,	3800,	4000,	4200,	4400,	4600,	4800,	5000,	
	--	700,	3300,	3550,	3800,	4000,	4200,	4450,	4600,	4800,	5000,	5200,	
	--	800,	3500,	3750,	3950,	4200,	4400,	4600,	4800,	5000,	5200,	5450,	
	--	900,	3650,	3900,	4150,	4350,	4600,	4800,	5000,	5200,	5450,	5650,	
	--	1000,	3800,	4050,	4300,	4500,	4750,	5000,	5200,	5400,	5600,	5800,	
	--	2000,	4900,	5200,	5500,	5750,	6050,	6300,	6550,	6800,	7050,	7300,	
	--	3000,	5700,	6050,	6400,	6700,	7000,	7300,	7600,	7850,	8150,	8450,	
	--	4000,	6400,	6750,	7100,	7450,	7800,	8150,	8500,	8800,	9150,	9450,	
	--	5000,	7000,	7400,	7800,	8200,	8600,	9000,	9300,	9700,	10100,	10400,	
	--	6000,	7500,	8000,	8500,	9000,	9500,	10000,	10500,	10500,	11000,	11500,	
	--	7000,	8500,	9000,	9500,	10000,	10000,	10500,	11000,	11500,	12000,	12500,	
	--	8000,	9000,	9500,	10000,	10500,	11000,	11500,	12000,	12500,	13000,	13500,	
	--	9000,	9500,	10000,	10500,	11500,	12000,	12500,	13000,	13500,	14000,	14500,	
	--	10000,	10000,	11000,	11500,	12000,	12500,	13500,	14000,	14500,	15000,	16000,	
	--	11000,	11000,	11500,	12500,	13000,	13500,	14500,	15000,	16000,	16500,	17000,	
	--	12000,	11500,	12500,	13000,	14000,	15000,	15500,	16500,	17000,	18000,	18500,	
	--	13000,	12500,	13500,	14500,	15000,	16000,	17000,	18000,	18500,	19500,	20000,	
	--	14000,	13500,	14500,	15500,	16500,	17500,	18500,	19500,	20000,	21000,	22000,	
	--	15000,	14500,	16000,	17000,	18000,	19000,	20000,	21000,	22000,	23000,	24000,	
	--},

	--MinLaunchDistData =
	--{
	--	19,		10,
	--
	--			100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
	--	600,	3350,	3400,	3400,	3500,	3550,	3600,	3750,	3800,	3900,	4050,	
	--	700,	3440,	3490,	3540,	3590,	3640,	3740,	3840,	3940,	4040,	4140,	
	--	800,	3580,	3580,	3630,	3680,	3780,	3830,	3930,	4080,	4130,	4280,	
	--	900,	3670,	3720,	3720,	3820,	3870,	3920,	4020,	4170,	4270,	4370,	
	--	1000,	3760,	3810,	3810,	3910,	3960,	4010,	4160,	4260,	4360,	4510,	
	--	2000,	4060,	4210,	4260,	4410,	4560,	4660,	4860,	5010,	5160,	5310,	
	--	3000,	4860,	4860,	4860,	4860,	4860,	4860,	4860,	4860,	4860,	4860,	
	--	4000,	6260,	6260,	6260,	6260,	6260,	6260,	6260,	6260,	6260,	6260,	
	--	5000,	7660,	7660,	7660,	7660,	7660,	7660,	7660,	7660,	7660,	7660,	
	--	6000,	9060,	9060,	9060,	9060,	9060,	9060,	9060,	9060,	9060,	9060,	
	--	7000,	10460,	10460,	10460,	10460,	10460,	10460,	10460,	10460,	10460,	10460,	
	--	8000,	11860,	11860,	11860,	11860,	11860,	11860,	11860,	11860,	11860,	11860,	
	--	9000,	13260,	13260,	13260,	13260,	13260,	13260,	13260,	13260,	13260,	13260,	
	--	10000,	14660,	14660,	14660,	14660,	14660,	14660,	14660,	14660,	14660,	14660,	
	--	11000,	16060,	16060,	16060,	16060,	16060,	16060,	16060,	16060,	16060,	16060,	
	--	12000,	17460,	17460,	17460,	17460,	17460,	17460,	17460,	17460,	17460,	17460,	
	--	13000,	18860,	18860,	18860,	18860,	18860,	18860,	18860,	18860,	18860,	18860,	
	--	14000,	20260,	20260,	20260,	20260,	20260,	20260,	20260,	20260,	20260,	20260,	
	--	15000,	21660,	21660,	21660,	21660,	21660,	21660,	21660,	21660,	21660,	21660,	
	--},

	--LaunchDistData =
	--{
	--	24,		10,
	--
	--			100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
	--	100,	1500,	1700,	2000,	2050,	2500,	2500,	2550,	3000,	3000,	3050,	
	--	200,	2500,	2500,	2500,	3000,	3000,	3500,	3500,	3500,	4000,	4000,	
	--	300,	3000,	4500,	3000,	3000,	3500,	3500,	4000,	4500,	4000,	4500,	
	--	400,	3500,	4000,	3500,	5000,	4000,	4500,	5500,	4500,	5500,	4500,	
	--	500,	5000,	4500,	5000,	5500,	4500,	6000,	5500,	6000,	6000,	6000,	
	--	600,	5500,	4000,	5500,	6000,	6000,	4500,	6000,	6000,	6500,	6500,	
	--	700,	4500,	7000,	6000,	5500,	5500,	6000,	6500,	6000,	6000,	6500,	
	--	800,	6500,	5500,	5000,	6500,	5500,	6000,	6000,	6500,	6500,	7000,	
	--	900,	4500,	5500,	6000,	6500,	8500,	8500,	6500,	8000,	8500,	8000,	
	--	1000,	5500,	5500,	7000,	6500,	8000,	6500,	6500,	8500,	8500,	8500,	
	--	2000,	6500,	7000,	7000,	8000,	8500,	10000,	10000,	10000,	10500,	11500,	
	--	3000,	7500,	8000,	8500,	9000,	9500,	11000,	10000,	11500,	11500,	12500,	
	--	4000,	8500,	9000,	10000,	10500,	12500,	11000,	12500,	12000,	12000,	13000,	
	--	5000,	10500,	12000,	12000,	12500,	13000,	13500,	14500,	14500,	13000,	14000,	
	--	6000,	12000,	12500,	12500,	13000,	14500,	13000,	14500,	15500,	15500,	17000,	
	--	7000,	14000,	13500,	15500,	15500,	15500,	16000,	16500,	17500,	17500,	17000,	
	--	8000,	15000,	15500,	17500,	16500,	17000,	16500,	19000,	19500,	19500,	19500,	
	--	9000,	16000,	17500,	18500,	16500,	18000,	20500,	21000,	21000,	21500,	21000,	
	--	10000,	17500,	19500,	20000,	20000,	19500,	20000,	21000,	22000,	22500,	23000,	
	--	11000,	20500,	21000,	20500,	24500,	22500,	22000,	22000,	23500,	23500,	25000,	
	--	12000,	22000,	22500,	22500,	23000,	24000,	26500,	25500,	25000,	26000,	27000,	
	--	13000,	21500,	25000,	24500,	25000,	26000,	25000,	26500,	27000,	29000,	29000,	
	--	14000,	29000,	26500,	27500,	27000,	27000,	28500,	28000,	29500,	29500,	31500,	
	--	15000,	28000,	29000,	30000,	28500,	30000,	30000,	31500,	35500,	31500,	34000,	
	--},

	--LaunchDistData =
	--{
	--	19,		10,
	--
	--			100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
	--	600,	5000,	3500,	4500,	4500,	4500,	5000,	7000,	8000,	5500,	7500,	
	--	700,	5000,	4000,	5000,	5000,	5000,	8500,	7000,	6000,	5500,	7500,	
	--	800,	4500,	4500,	6000,	5000,	5500,	8500,	7000,	6000,	5500,	6500,	
	--	900,	5500,	5000,	6000,	5000,	5500,	8500,	7000,	7500,	7500,	9500,	
	--	1000,	5500,	5000,	7500,	6500,	5500,	8500,	7500,	8500,	7500,	10000,	
	--	2000,	6500,	6500,	7500,	8500,	9000,	9500,	9500,	9000,	9500,	10500,	
	--	3000,	7000,	8500,	8000,	9000,	10000,	9000,	10500,	9500,	12000,	11500,	
	--	4000,	8500,	8500,	8500,	10500,	10500,	10500,	10000,	12000,	12000,	12500,	
	--	5000,	9500,	9500,	9500,	11000,	11500,	11000,	11000,	13000,	13000,	13000,	
	--	6000,	10000,	10000,	10000,	11000,	12000,	12000,	12000,	13500,	14500,	13500,	
	--	7000,	12500,	13500,	11000,	12000,	11500,	13500,	12500,	14000,	16000,	16000,	
	--	8000,	12000,	12500,	13500,	12500,	13000,	14000,	15000,	14000,	15000,	16000,	
	--	9000,	15500,	14500,	14500,	15500,	13500,	14000,	15000,	16000,	15500,	16000,	
	--	10000,	17000,	15500,	15500,	17500,	15500,	18000,	19000,	20500,	17000,	18000,	
	--	11000,	16000,	18500,	18000,	19000,	19000,	19500,	17500,	19500,	19000,	17500,	
	--	12000,	20000,	18000,	21000,	21500,	19000,	19500,	17500,	19000,	20500,	23000,	
	--	13000,	20500,	22000,	19500,	20000,	21000,	21000,	21000,	22000,	22000,	21000,	
	--	14000,	19500,	23500,	20500,	24000,	22000,	21500,	22500,	21500,	25000,	26000,	
	--	15000,	25000,	23500,	26000,	20500,	24500,	25000,	24500,	27500,	27000,	26000,	
	--},

	--LaunchDistData =
	--{
	--	24,		10,
	--
	--			100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
	--	100,	1487,	1680,	1867,	2062,	2244,	2404,	2575,	2747,	2902,	3066,	
	--	200,	2082,	2287,	2491,	2694,	2881,	3055,	3237,	3419,	3584,	3756,	
	--	300,	2483,	2700,	2907,	3116,	3316,	3489,	3682,	3875,	4043,	4225,	
	--	400,	2846,	3060,	3268,	3483,	3681,	3859,	4054,	4248,	4425,	4606,	
	--	500,	3202,	3416,	3628,	3843,	4046,	4223,	4416,	4611,	4790,	4971,	
	--	600,	3554,	3769,	3984,	4195,	4399,	4577,	4772,	4971,	5145,	5327,	
	--	700,	3902,	4118,	4337,	4546,	4752,	4930,	5131,	5321,	5505,	5682,	
	--	800,	4245,	4467,	4683,	4895,	5098,	5278,	5479,	5673,	5855,	6035,	
	--	900,	4591,	4808,	5025,	5242,	5448,	5626,	5827,	6022,	6203,	6392,	
	--	1000,	4929,	5150,	5364,	5586,	5786,	5974,	6171,	6367,	6547,	6735,	
	--	2000,	8181,	8407,	8645,	8857,	9067,	9262,	9473,	9677,	9875,	10065,	
	--	3000,	11116,	11399,	11635,	11867,	12112,	12327,	12543,	12754,	12968,	13167,	
	--	4000,	13816,	14177,	14433,	14697,	14951,	15227,	15387,	15630,	15831,	16073,	
	--	5000,	16101,	16513,	16902,	17247,	17558,	17773,	18086,	18335,	18581,	18855,	
	--	6000,	18214,	18613,	19075,	19465,	19808,	20141,	20481,	20860,	21107,	21418,	
	--	7000,	20321,	20719,	21144,	21677,	22046,	22391,	22739,	23136,	23533,	23836,	
	--	8000,	22220,	22807,	23320,	23759,	24122,	24572,	25068,	25386,	25771,	26168,	
	--	9000,	24076,	24673,	25289,	25826,	26308,	26716,	27278,	27597,	28079,	28354,	
	--	10000,	25991,	26629,	27236,	27808,	28441,	28856,	29381,	29766,	30229,	30652,	
	--	11000,	27945,	28637,	29270,	29872,	30439,	31067,	31494,	32044,	32407,	32880,	
	--	12000,	29935,	30650,	31325,	31959,	32543,	33200,	33754,	34231,	34776,	35150,	
	--	13000,	31936,	32659,	33376,	34053,	34703,	35318,	35944,	36531,	37012,	37520,	
	--	14000,	33909,	34722,	35539,	36254,	36917,	37531,	38133,	38727,	39217,	39757,	
	--	15000,	35962,	36825,	37623,	38304,	39016,	39655,	40273,	40854,	41443,	42015,	
	--},

	--Direct Attack data
	LaunchDistData =
	{
		19,		10,
	
				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		600,	5283,	4033,	4308,	4558,	4765,	5016,	4764,	6098,	4947,	5459,	
		700,	4571,	4092,	4367,	7138,	5256,	5353,	6443,	5672,	6021,	6071,	
		800,	5781,	5817,	4918,	5567,	6725,	7577,	5391,	6732,	7491,	7419,	
		900,	4847,	4940,	5821,	6647,	7269,	6532,	5943,	6742,	8942,	6918,	
		1000,	5911,	5622,	7181,	6349,	5878,	7666,	8238,	6808,	8505,	7655,	
		2000,	7166,	6832,	8152,	8476,	8512,	8711,	9425,	9463,	9879,	9992,	
		3000,	8919,	8382,	9394,	9626,	9695,	9777,	9850,	10114,	10699,	11520,	
		4000,	10660,	9874,	10567,	10936,	11062,	10872,	10995,	13029,	12446,	13501,	
		5000,	11313,	11756,	11881,	11499,	11736,	13273,	12729,	12664,	13065,	14249,	
		6000,	11923,	12385,	12732,	13444,	14251,	13760,	13404,	15224,	14974,	15201,	
		7000,	12909,	13401,	14309,	13993,	14986,	15068,	15502,	15272,	16767,	15607,	
		8000,	14670,	15268,	15498,	16506,	15867,	16032,	16641,	17277,	18096,	17861,	
		9000,	16323,	17458,	17284,	17556,	17462,	18148,	17463,	17763,	18115,	19153,	
		10000,	18410,	17939,	18837,	18897,	19124,	19710,	19794,	19407,	19184,	19849,	
		11000,	20300,	18886,	20128,	19133,	21129,	20597,	20838,	21493,	21866,	22766,	
		12000,	21414,	21318,	20241,	21061,	22052,	23042,	22657,	23361,	23062,	23520,	
		13000,	21219,	22213,	22917,	22995,	24093,	23738,	23602,	24603,	24601,	24439,	
		14000,	23694,	25204,	23738,	24751,	24728,	25456,	25393,	26383,	26180,	26213,	
		15000,	25310,	26762,	26563,	26865,	27317,	26410,	28481,	28045,	28301,	27492,	
	},

	--Loft Attack data
	--NOTE: Altitudes, velocities and distances are from the start of the loft maneuver, for a 30 degree loft, not from launch point. Missile should not be launched below 600m in either mode!!!
	--LoftStartData =
	--{
	--	24,		10,

	--			100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
	--	100,	13883,	15123,	16462,	17915,	19497,	21231,	23140,	25243,	27555,	30105,	
	--	200,	14039,	15280,	16624,	18081,	19669,	21414,	23334,	25451,	27781,	30353,	
	--	300,	14193,	15437,	16783,	18247,	19843,	21596,	23528,	25660,	28007,	30603,	
	--	400,	14346,	15591,	16942,	18413,	20016,	21779,	23724,	25871,	28237,	30857,	
	--	500,	14494,	15745,	17101,	18578,	20189,	21963,	23920,	26083,	28469,	31113,	
	--	600,	14644,	15898,	17260,	18742,	20363,	22147,	24117,	26296,	28703,	31372,	
	--	700,	14792,	16050,	17417,	18907,	20536,	22332,	24316,	26511,	28940,	31635,	
	--	800,	14938,	16200,	17574,	19071,	20710,	22517,	24515,	26729,	29179,	31900,	
	--	900,	15084,	16350,	17729,	19237,	20884,	22704,	24716,	26948,	29420,	32171,	
	--	1000,	15227,	16500,	17885,	19401,	21059,	22890,	24920,	27170,	29664,	32444,	
	--	2000,	16630,	17972,	19445,	21064,	22845,	24828,	27043,	29517,	32292,	35444,	
	--	3000,	18003,	19447,	21040,	22801,	24752,	26940,	29407,	32200,	35393,	39047,	
	--	4000,	19398,	20976,	22727,	24676,	26852,	29324,	32157,	35378,	39105,	43430,	
	--	5000,	20858,	22607,	24565,	26762,	29264,	32119,	35403,	39186,	43548,	48568,	
	--	6000,	22424,	24399,	26648,	29182,	32077,	35412,	39239,	43621,	48634,	54359,	
	--	7000,	24178,	26457,	29050,	31995,	35361,	39213,	43595,	48580,	54267,	60734,	
	--	8000,	26187,	28823,	31810,	35206,	39058,	43423,	48367,	53987,	60368,	67562,	
	--	9000,	28461,	31479,	34893,	38734,	43066,	47954,	53491,	59754,	66801,	74692,	
	--	10000,	30975,	34383,	38204,	42492,	47316,	52761,	58889,	65768,	73420,	81927,	
	--	11000,	33687,	37469,	41699,	46439,	51757,	57709,	64360,	71757,	79950,	89008,	
	--	12000,	36439,	40586,	45220,	50407,	56181,	62604,	69722,	77607,	86292,	95828,	
	--	13000,	39189,	43700,	48736,	54332,	60529,	67369,	74922,	83249,	92363,	102337,	
	--	14000,	41908,	46786,	52186,	58161,	64731,	71956,	79910,	88627,	98132,	108455,	
	--	15000,	44588,	49794,	55536,	61849,	68755,	76339,	84654,	93720,	103546,	114135,	
	--},

	LoftStartData =
	{
		24,		10,
	
				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		100,	13821,	15075,	16421,	17877,	19461,	21201,	23111,	25217,	27531,	30082,	
		200,	13978,	15233,	16583,	18045,	19635,	21383,	23305,	25425,	27756,	30330,	
		300,	14132,	15388,	16743,	18210,	19808,	21565,	23500,	25633,	27984,	30581,	
		400,	14286,	15546,	16904,	18377,	19982,	21749,	23696,	25845,	28213,	30834,	
		500,	14437,	15699,	17062,	18542,	20156,	21933,	23892,	26058,	28445,	31090,	
		600,	14586,	15853,	17221,	18707,	20330,	22118,	24090,	26271,	28679,	31350,	
		700,	14735,	16004,	17379,	18873,	20503,	22302,	24289,	26487,	28916,	31613,	
		800,	14881,	16157,	17535,	19037,	20679,	22488,	24489,	26705,	29155,	31881,	
		900,	15027,	16308,	17692,	19201,	20853,	22674,	24691,	26925,	29397,	32150,	
		1000,	15173,	16456,	17849,	19366,	21028,	22861,	24894,	27147,	29642,	32424,	
		2000,	16580,	17933,	19411,	21032,	22818,	24803,	27019,	29496,	32272,	35425,	
		3000,	17958,	19411,	21009,	22773,	24727,	26917,	29386,	32180,	35372,	39024,	
		4000,	19357,	20942,	22698,	24650,	26829,	29304,	32136,	35355,	39078,	43398,	
		5000,	20818,	22575,	24537,	26738,	29240,	32094,	35374,	39154,	43513,	48528,	
		6000,	22385,	24367,	26620,	29154,	32047,	35380,	39203,	43580,	48588,	54308,	
		7000,	24138,	26420,	29013,	31958,	35322,	39170,	43548,	48528,	54211,	60674,	
		8000,	26136,	28775,	31765,	35159,	39009,	43369,	48309,	53926,	60303,	67492,	
		9000,	28400,	31422,	34837,	38677,	43005,	47891,	53424,	59684,	66726,	74611,	
		10000,	30903,	34314,	38136,	42423,	47245,	52686,	58812,	65689,	73336,	81838,	
		11000,	33600,	37387,	41618,	46358,	51675,	57626,	64275,	71669,	79858,	88911,	
		12000,	36336,	40490,	45128,	50316,	56089,	62512,	69628,	77511,	86194,	95725,	
		13000,	39073,	43590,	48632,	54230,	60428,	67268,	74823,	83149,	92259,	102230,	
		14000,	41785,	46663,	52070,	58049,	64622,	71848,	79804,	88522,	98027,	108346,	
		15000,	44463,	49663,	55408,	61727,	68639,	76224,	84541,	93609,	103437,	114027,	
	},
	
	--NOTE: DATA IS 2D. Calculating 3D WAR for Shrike is pointless, it MUST be launched at target bearing for a reasonable pk
	RminData2 = {
		4380.272953949102, 0, 0, 0, 0,
		0.8527581731836751, 0, 0, 0, 0,
		14.201232905360822, 0, 0, 0, 0,
		419.2731585964053, 0, 0, 0, 0,
		1.588007816157394e-05, 0, 0, 0, 0,
		-0.017470759427041686, 0, 0, 0, 0,
		-1.4159818087262985, 0, 0, 0, 0,
		-0.001053030530930026, 0, 0, 0, 0,
		-0.04642911310353466, 0, 0, 0, 0,
		-0.49919642820388116, 0, 0, 0, 0,
		-2.817939445338072e-10, 0, 0, 0, 0,
		8.54124140895951e-06, 0, 0, 0, 0,
		-0.09531615785462998, 0, 0, 0, 0,
		1.3773800902923737e-07, 0, 0, 0, 0,
		2.375456450255647e-06, 0, 0, 0, 0,
		2.226763296871076e-06, 0, 0, 0, 0,
		0.0006523600328835411, 0, 0, 0, 0,
		0.000581309547242238, 0, 0, 0, 0,
		0.007209468071458524, 0, 0, 0, 0,
		0.0001518750943085837, 0, 0, 0, 0,
	},
	LoftData2 = {
		3254.085540727881, 0, 0, 0, 0,
		2.1050363316189795, 0, 0, 0, 0,
		16.16527777287695, 0, 0, 0, 0,
		457.739457346472, 0, 0, 0, 0,
		-8.509709682039307e-05, 0, 0, 0, 0,
		-0.019419928685534705, 0, 0, 0, 0,
		-1.8267994361067494, 0, 0, 0, 0,
		-0.0010150310446309693, 0, 0, 0, 0,
		-0.0653362366062799, 0, 0, 0, 0,
		-0.42005961246243084, 0, 0, 0, 0,
		2.0913595334776434e-09, 0, 0, 0, 0,
		9.63110969916652e-06, 0, 0, 0, 0,
		-0.06893330452720346, 0, 0, 0, 0,
		1.3811786130703416e-07, 0, 0, 0, 0,
		3.4035217209411414e-06, 0, 0, 0, 0,
		2.2993622679303242e-06, 0, 0, 0, 0,
		0.0006219283664115248, 0, 0, 0, 0,
		0.0005478427394223036, 0, 0, 0, 0,
		0.005781302520696352, 0, 0, 0, 0,
		0.00014426388702245698, 0, 0, 0, 0,
	},
	RmaxData2 = {
		1789.3142537829049, 0, 0, 0, 0,
		2.5344868796668667, 0, 0, 0, 0,
		21.991036575542722, 0, 0, 0, 0,
		418.89023300334253, 0, 0, 0, 0,
		-7.468438273192621e-05, 0, 0, 0, 0,
		-0.03689916433398732, 0, 0, 0, 0,
		2.456246756947492, 0, 0, 0, 0,
		-0.0015765534435510538, 0, 0, 0, 0,
		-0.049094603967603415, 0, 0, 0, 0,
		-0.2537764403290573, 0, 0, 0, 0,
		1.3902497696389698e-09, 0, 0, 0, 0,
		2.8475670379419573e-05, 0, 0, 0, 0,
		-0.11981907752464087, 0, 0, 0, 0,
		1.4541191243789984e-07, 0, 0, 0, 0,
		2.648430790941236e-06, 0, 0, 0, 0,
		2.5860549565230867e-06, 0, 0, 0, 0,
		0.00041718867092244063, 0, 0, 0, 0,
		0.0002856440196563885, 0, 0, 0, 0,
		0.006935998630912289, 0, 0, 0, 0,
		0.00014091907596760844, 0, 0, 0, 0,
	},	

	controller = {
		boost_start = 0,
		march_start = 0,
	},

	boost =	predefined_engine("Rocketdyne_Mk39"),
	march = predefined_engine("DISABLED_STAGE"),

	fm = {
		mass				= 180,  
		caliber				= 0.2,  
		wind_sigma			= 0.0,
		wind_time			= 0.0,
		tail_first			= 1,
		fins_part_val		= 0,
		rotated_fins_inp	= 0,
		delta_max			= math.rad(7),
		draw_fins_conv		= {0,0.28,0.28},
		L					= 0.2,
		S					= 0.0324,--*0.81,
		Ix					= 3.7,
		Iy					= 139,
		Iz					= 139,
		
		Mxd					= 0.3 * 57.3,
		Mxw					= -44.5,
		Mx0					= 0.03,
	
		table_scale	= 0.2,
		table_degree_values = 1,
	--	Mach	  | 0.0		0.2		0.4		0.6		0.8		1.0		1.2		1.4		1.6		1.8		2.0		2.2		2.4		2.6		2.8		3.0		3.2		3.4		3.6		3.8		4.0	 |
		Cx0		= {0.2822, 0.2822, 0.2822, 0.2822, 0.2905, 0.913 , 1.0541, 1.0209, 0.9877, 0.9296, 0.8715, 0.83  , 0.7885, 0.7553, 0.7221, 0.6972, 0.6723, 0.6474, 0.6308, 0.6142, 0.5976},
		CxB		= {0.0913, 0.0913, 0.0913, 0.0913, 0.0913, 0.1494, 0.1577, 0.1411, 0.1328, 0.1162, 0.1079, 0.0996, 0.0996, 0.0913, 0.0913, 0.083 , 0.0747, 0.0747, 0.0664, 0.0664, 0.0581},
		K1		= { 0.00448, 0.00448, 0.00448, 0.00448, 0.00448, 0.00448, 0.00448, 0.00448, 0.00416, 0.00384, 0.0036 , 0.00328, 0.00296, 0.00288, 0.00272, 0.00256, 0.00248, 0.0024 , 0.00232, 0.00216, 0.00208},
		K2		= { 0.004455, 0.004455, 0.004455, 0.004455, 0.004455, 0.004455, 0.004455, 0.004455, 0.004131, 0.003807, 0.003483, 0.002997, 0.002511, 0.002592, 0.002673, 0.002835, 0.002916, 0.002997, 0.003078, 0.003159, 0.00324 },
		Cya		= { 0.9234, 0.9234, 0.9234, 0.9234, 0.9234, 1.1502, 1.1826, 1.1259, 1.0692, 0.9315, 0.8586, 0.81  , 0.7614, 0.7209, 0.6723, 0.6318, 0.5913, 0.5589, 0.5265, 0.4941, 0.4617 },
		Cza		= { 0.9234, 0.9234, 0.9234, 0.9234, 0.9234, 1.1502, 1.1826, 1.1259, 1.0692, 0.9315, 0.8586, 0.81  , 0.7614, 0.7209, 0.6723, 0.6318, 0.5913, 0.5589, 0.5265, 0.4941, 0.4617 },
		Mya		= { -0.35,	-0.35},
		Mza		= { -0.35,	-0.35},
		Myw		= { -1.5,	-1.5},
		Mzw		= { -1.5,	-1.5},
		A1trim	= { 0.0,	0.0},
		A2trim	= { 0.0,	0.0},
			
		model_roll = math.rad(45),
		fins_stall = 0,
		wing_lift_factor = 0.168
	},


	radio_seeker = {
		FOV					= math.rad(80),
		op_time				= 150,
		keep_aim_time		= 0.1,
		pos_memory_time		= 0.1,
		sens_near_dist		= 100,
		sens_far_dist		= 50000,
		err_correct_time	= 2.,
		err_val				= 0.003,
		calc_aim_dist		= 500000,
		blind_rad_val		= 1,
		blind_ctrl_dist		= 360,
		aim_y_offset		= 0,
		min_sens_rad_val	= 0.0000025,
		max_random_boresight_error = 0.017,
		filter_by_frequency	= true
	},

	fuze = {
		default_arm_delays			= { 3 },
		default_proximity_radius	= 10,
		is_neg_cls_rate_req			= true,
		is_proxy_tdd_always_enabled	= true,
	},

	ap = {
		deadzone = math.rad(0),
		deflection = math.rad(7),
		EAS_Cp = {0.30033732,  0.94117171, 17.82526047, -0.02109645, -0.03571429, 0.35952381, -1.15797619, 1.20857143},
	},

	actuator = {
		D = 500,
		Tf = 0,
		T1 = 0,
		T2 = 0.005,
		max_omega = math.rad(210),
		max_delta = math.rad(7),
		fin_stall = 0,
		sim_count = 4,
	},

	gyro = {
		init_roll = math.rad(45)
	},

	smoke = {
		transparency	= 0.8,
		color			= {1, 1, 1},
		intensity		= 3,
		duration		= 60,
		flare			= true
	},

	warhead		= predefined_warhead("AGM_45"),

	shape_table_data =
	{
		{
			name		= "HB_F-4E_EXT_AGM45",
			file		= "HB_F-4E_EXT_AGM45",
			life		= 1,
			fire		= { 0, 1},
			username	= _("AGM-45A"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},
}
declare_weapon(AGM_45A)

-- AGM_45B =
-- {
-- 	category			= CAT_MISSILES,
-- 	name				= "AGM_45B",
-- 	user_name			= _("AGM-45B Shrike ARM"),
-- 	display_name_short	= "AGM-45",
-- 	scheme				= "agm_45",
-- 	class_name			= "wAmmunitionSelfHoming",
-- 	model				= "agm-45",
-- 	mass				= 185,

-- 	wsTypeOfWeapon		= {wsType_Weapon, wsType_Missile, wsType_AS_Missile, WSTYPE_PLACEHOLDER},

-- 	Escort				= 0,
-- 	Head_Type			= 3,
-- 	sigma				= {0, 0, 0},
-- 	M					= 185,
-- 	H_max				= 24400,
-- 	H_min				= -1,
-- 	Diam				= 203,
-- 	Cx_pil				= 4,		--? Check
-- 	D_max				= 31000,
-- 	D_min				= 3000,
-- 	Head_Form			= 1,
-- 	Life_Time			= 300,
-- 	Nr_max				= 12,
-- 	v_min				= 170,
-- 	v_mid				= 400,
-- 	Mach_max			= 2,
-- 	t_b					= 0,
-- 	t_acc				= 5,
-- 	t_marsh				= 15,
-- 	Range_max			= 31000,
-- 	H_min_t				= 0,
-- 	Fi_start			= 0.5,
-- 	Fi_rak				= 3.14152,
-- 	Fi_excort			= 1,
-- 	Fi_search			= 99.9,
-- 	OmViz_max			= 99.9,
-- 	X_back				= 0,
-- 	Y_back				= 0,
-- 	Z_back				= 0,
-- 	Reflection			= 0.08,
-- 	KillDistance		= 10,

-- 	SeekerGen = 1,  -- Seeker generation

-- 	manualWeaponFlag	= 1,
	
-- 	-- might need to be regenerated again at some point but matches current fm
	
-- 	MinLaunchDistData =
-- 	{
-- 		24,		10,

-- 				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
-- 		100,	1150,	1300,	1500,	1650,	1800,	1950,	2150,	2300,	2450,	2600,	
-- 		200,	1550,	1750,	1900,	2100,	2300,	2450,	2600,	2800,	3000,	3150,	
-- 		300,	1850,	2050,	2200,	2400,	2600,	2800,	2950,	3150,	3350,	3550,	
-- 		400,	2050,	2250,	2450,	2650,	2850,	3050,	3250,	3450,	3650,	3850,	
-- 		500,	2250,	2500,	2700,	2850,	3100,	3300,	3450,	3700,	3900,	4100,	
-- 		600,	2450,	2650,	2850,	3100,	3300,	3500,	3700,	3900,	4150,	4350,	
-- 		700,	2600,	2850,	3050,	3250,	3500,	3700,	3900,	4100,	4350,	4550,	
-- 		800,	2750,	3000,	3200,	3400,	3650,	3850,	4050,	4300,	4550,	4750,	
-- 		900,	2900,	3150,	3350,	3550,	3800,	4000,	4200,	4450,	4700,	4950,	
-- 		1000,	3050,	3250,	3500,	3700,	3950,	4150,	4400,	4600,	4900,	5150,	
-- 		2000,	4050,	4300,	4550,	4850,	5100,	5400,	5650,	5950,	6250,	6550,	
-- 		3000,	4750,	5050,	5350,	5650,	6000,	6300,	6600,	6950,	7350,	7650,	
-- 		4000,	5300,	5650,	6000,	6350,	6700,	7050,	7450,	7900,	8300,	8650,	
-- 		5000,	5800,	6200,	6600,	7000,	7400,	7800,	8300,	8800,	9300,	9700,	
-- 		6000,	6500,	7000,	7500,	8000,	8500,	9000,	9500,	10000,	10500,	11000,	
-- 		7000,	7000,	7500,	8000,	8500,	9000,	9500,	10500,	11000,	11500,	12000,	
-- 		8000,	7500,	8000,	8500,	9000,	10000,	10500,	11000,	12000,	12500,	13000,	
-- 		9000,	8000,	8500,	9500,	10000,	11000,	11500,	12000,	13000,	13500,	14000,	
-- 		10000,	8500,	9500,	10000,	11000,	11500,	12500,	13000,	14000,	14500,	15000,	
-- 		11000,	9000,	10000,	11000,	12000,	12500,	13500,	14000,	15000,	15500,	16500,	
-- 		12000,	10000,	11000,	12000,	13000,	13500,	14500,	15500,	16000,	17000,	18000,	
-- 		13000,	10500,	11500,	13000,	14000,	15000,	16000,	16500,	17500,	18500,	19500,	
-- 		14000,	11500,	12500,	14000,	15000,	16000,	17000,	18000,	19000,	20000,	21000,	
-- 		15000,	12500,	13500,	15000,	16000,	17500,	18500,	19500,	20500,	22000,	23000,	
-- 	},	
	
-- 	LaunchDistData =
-- 	{
-- 		24,		10,

-- 				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
-- 		100,	1150,	1300,	1500,	1650,	1800,	2000,	2150,	2300,	2500,	2600,	
-- 		200,	1550,	2000,	3500,	2100,	2300,	2500,	2600,	3500,	3500,	3150,	
-- 		300,	1850,	4500,	2200,	2500,	2600,	3000,	3000,	3500,	3500,	4000,	
-- 		400,	4000,	3500,	2500,	3000,	4000,	3500,	5000,	4000,	4000,	4500,	
-- 		500,	2500,	3000,	4000,	5000,	5500,	6000,	5500,	5500,	5500,	5000,	
-- 		600,	6000,	6500,	6000,	6500,	3500,	5500,	6000,	5500,	5000,	6000,	
-- 		700,	6500,	5500,	5000,	5500,	5000,	6000,	4500,	4500,	9000,	6500,	
-- 		800,	6000,	7000,	5500,	8500,	7500,	6000,	9000,	9500,	6000,	9500,	
-- 		900,	6000,	6000,	6500,	7000,	9500,	8000,	7000,	9000,	8000,	10000,	
-- 		1000,	6000,	5500,	9500,	6500,	10000,	9000,	9500,	6000,	6500,	11500,	
-- 		2000,	9000,	10500,	9500,	11000,	9500,	10500,	11500,	11500,	13000,	13000,	
-- 		3000,	10500,	10500,	10500,	12500,	12000,	11500,	12500,	11500,	12500,	14000,	
-- 		4000,	10000,	11500,	11500,	12500,	12000,	13500,	13500,	14500,	14500,	15500,	
-- 		5000,	10500,	13000,	12500,	12500,	13000,	14500,	14500,	15500,	15500,	16000,	
-- 		6000,	12500,	12500,	15000,	14500,	14500,	15000,	17000,	15500,	17500,	17500,	
-- 		7000,	12500,	12500,	14000,	15500,	17000,	16000,	16000,	17000,	17000,	17500,	
-- 		8000,	16500,	17000,	17000,	16000,	15000,	16500,	20000,	19500,	18500,	19500,	
-- 		9000,	16000,	17000,	20000,	17000,	18500,	19500,	17500,	19000,	22500,	22500,	
-- 		10000,	17000,	17500,	18000,	20500,	20500,	21000,	22500,	20500,	20500,	23000,	
-- 		11000,	18000,	19000,	19500,	20500,	22000,	22000,	23500,	26500,	25000,	23500,	
-- 		12000,	19500,	20500,	23500,	23000,	23000,	23500,	25000,	26000,	24500,	27000,	
-- 		13000,	20500,	23500,	23500,	24000,	24500,	25500,	26500,	28000,	28500,	28500,	
-- 		14000,	22500,	23500,	24500,	24500,	26000,	27500,	29000,	29000,	31500,	31500,	
-- 		15000,	24000,	24500,	26000,	27000,	27500,	28500,	32500,	30000,	33500,	34000,	
-- 	},

-- 	controller = {
-- 		boost_start = 0,
-- 		march_start = 1,
-- 	},

-- 	boost = specialize_engine_parameters(
-- 		predefined_engine("Aerojet_Mk78").boost,
-- 		{ nozzle_position = {{ -1, -0.1, 0 }} }
-- 	),

-- 	march = specialize_engine_parameters(
-- 		predefined_engine("Aerojet_Mk78").march,
-- 		{ nozzle_position = {{ -1, -0.1, 0 }} }
-- 	),

-- 	fm = {
-- 		mass				= 185,  
-- 		caliber				= 0.2,  
-- 		wind_sigma			= 0.0,
-- 		wind_time			= 0.0,
-- 		tail_first			= 1,
-- 		fins_part_val		= 0,
-- 		rotated_fins_inp	= 0,
-- 		delta_max			= math.rad(7),
-- 		draw_fins_conv		= {math.rad(90),1,1},
-- 		L					= 0.2,
-- 		S					= 0.0324,
-- 		Ix					= 3.7,
-- 		Iy					= 143,
-- 		Iz					= 143,

-- 		Mxd					= 0.3 * 57.3,
-- 		Mxw					= -44.5,
-- 		Mx0					= 0.03,

-- 		table_scale	= 0.2,
-- 		table_degree_values = 1,
-- 	--	Mach	  | 0.0		0.2		0.4		0.6		0.8		1.0		1.2		1.4		1.6		1.8		2.0		2.2		2.4		2.6		2.8		3.0		3.2		3.4		3.6		3.8		4.0	 |
-- 		Cx0		= {0.2822, 0.2822, 0.2822, 0.2822, 0.2905, 0.913 , 1.0541, 1.0209, 0.9877, 0.9296, 0.8715, 0.83  , 0.7885, 0.7553, 0.7221, 0.6972, 0.6723, 0.6474, 0.6308, 0.6142, 0.5976},
-- 		CxB		= {0.0913, 0.0913, 0.0913, 0.0913, 0.0913, 0.1494, 0.1577, 0.1411, 0.1328, 0.1162, 0.1079, 0.0996, 0.0996, 0.0913, 0.0913, 0.083 , 0.0747, 0.0747, 0.0664, 0.0664, 0.0581},
-- 		K1		= { 0.00448, 0.00448, 0.00448, 0.00448, 0.00448, 0.00448, 0.00448, 0.00448, 0.00416, 0.00384, 0.0036 , 0.00328, 0.00296, 0.00288, 0.00272, 0.00256, 0.00248, 0.0024 , 0.00232, 0.00216, 0.00208},
-- 		K2		= { 0.004455, 0.004455, 0.004455, 0.004455, 0.004455, 0.004455, 0.004455, 0.004455, 0.004131, 0.003807, 0.003483, 0.002997, 0.002511, 0.002592, 0.002673, 0.002835, 0.002916, 0.002997, 0.003078, 0.003159, 0.00324 },
-- 		Cya		= { 0.9234, 0.9234, 0.9234, 0.9234, 0.9234, 1.1502, 1.1826, 1.1259, 1.0692, 0.9315, 0.8586, 0.81  , 0.7614, 0.7209, 0.6723, 0.6318, 0.5913, 0.5589, 0.5265, 0.4941, 0.4617 },
-- 		Cza		= { 0.9234, 0.9234, 0.9234, 0.9234, 0.9234, 1.1502, 1.1826, 1.1259, 1.0692, 0.9315, 0.8586, 0.81  , 0.7614, 0.7209, 0.6723, 0.6318, 0.5913, 0.5589, 0.5265, 0.4941, 0.4617 },
-- 		Mya		= { -0.2,	-0.2},
-- 		Mza		= { -0.2,	-0.2},
-- 		Myw		= { -1.0,	-1.0},
-- 		Mzw		= { -1.0,	-1.0},
-- 		A1trim	= { 0.0,	0.0},
-- 		A2trim	= { 0.0,	0.0},
		
-- 		model_roll = math.rad(45),
-- 		fins_stall = 0,
-- 		wing_lift_factor = 0.168
-- 	},

-- 	radio_seeker = {
-- 		FOV					= math.rad(45),
-- 		op_time				= 150,
-- 		keep_aim_time		= 0.1,
-- 		pos_memory_time		= 0.1,
-- 		sens_near_dist		= 300,
-- 		sens_far_dist		= 50000,
-- 		err_correct_time	= 2.8,
-- 		err_val				= 0.01,
-- 		calc_aim_dist		= 500000,
-- 		blind_rad_val		= 0.2,
-- 		blind_ctrl_dist		= 2000,
-- 		aim_y_offset		= 0,
-- 		min_sens_rad_val	= 0.0000025,
-- 		filter_by_frequency	= true
-- 	},

-- 	fuze = {
-- 		default_arm_delays			= { 10 },
-- 		default_proximity_radius	= 10,
-- 		is_neg_cls_rate_req			= true,
-- 		is_proxy_tdd_always_enabled	= true,
-- 	},

-- 	ap = {
-- 		deadzone = math.rad(0),
-- 		deflection = math.rad(7),
-- 		EAS_Cp = {0.30033732,  0.94117171, 17.82526047, -0.02109645, -0.03571429, 0.35952381, -1.15797619, 1.20857143}
-- 	},

-- 	gyro = {
-- 		init_roll = math.rad(45)
-- 	},

-- 	actuator = {
-- 		D = 500,
-- 		Tf = 0,
-- 		T1 = 0,
-- 		T2 = 0.005,
-- 		max_omega = math.rad(210),
-- 		max_delta = math.rad(7),
-- 		fin_stall = 0,
-- 		sim_count = 4,
-- 	},

-- 	smoke = {
-- 		transparency	= 0.8,
-- 		color			= {1, 1, 1},
-- 		intensity		= 3,
-- 		duration		= 60,
-- 		flare			= true
-- 	},

-- 	warhead		= predefined_warhead("AGM_45"),

-- 	shape_table_data = {{
-- 		name		= "AGM_45B",
-- 		file		= "agm-45",
-- 		username	= _("AGM-45B"),
-- 		index		= WSTYPE_PLACEHOLDER,
-- 	}},
-- }

AGM_45B 								= deepcopy(AGM_45A)
AGM_45B.name 							= "AGM_45B"
AGM_45B.user_name 						= _("AGM-45B Shrike ARM")
AGM_45B.display_name_short 				= "AGM-45B"
AGM_45B.mass							= 185
AGM_45B.M								= AGM_45B.mass
AGM_45B.wsTypeOfWeapon					= {wsType_Weapon, wsType_Missile, wsType_AS_Missile, WSTYPE_PLACEHOLDER}
AGM_45B.boost 							= specialize_engine_parameters(predefined_engine("Aerojet_Mk78").boost,	{ nozzle_position = {{ -1, 0, 0 }} })
AGM_45B.controller.march_start			= AGM_45B.boost.work_time
-- AGM_45B.controller.march_start			= 1
AGM_45B.march 							= specialize_engine_parameters(predefined_engine("Aerojet_Mk78").march,	{ nozzle_position = {{ -1, 0, 0 }} })

AGM_45B.fm.mass 						= AGM_45B.mass
AGM_45B.shape_table_data[1].name		= AGM_45B.name
AGM_45B.shape_table_data[1].file		= AGM_45B.model
AGM_45B.shape_table_data[1].username	= _("AGM-45B")
AGM_45B.shape_table_data[1].index 		= AGM_45B.wsTypeOfWeapon[4]

declare_weapon(AGM_45B)

AGM_78B = {
	category			= CAT_MISSILES,
	name				= "AGM_78B",
	user_name			= _("AGM-78B Standard ARM"),
	display_name_short	= "AGM-78",
	scheme				= "agm_78",
	class_name			= "wAmmunitionSelfHoming",
	model				= "HB_F-4E_ORD_AGM78",	--placeholder
	mass				= 620,

	wsTypeOfWeapon		= {wsType_Weapon, wsType_Missile, wsType_AS_Missile, WSTYPE_PLACEHOLDER},

	Escort				= 0,
	Head_Type			= 3,
	sigma				= {0, 0, 0},
	M					= 620,
	H_max				= 24400,
	H_min				= -1,
	Diam				= 203,
	Cx_pil				= 8,		--? Check
	D_max				= 65000,
	D_min				= 3000,
	Head_Form			= 1,
	Life_Time			= 300,
	Nr_max				= 12,
	v_min				= 170,
	v_mid				= 400,
	Mach_max			= 2.5,
	t_b					= 0,
	t_acc				= 5,
	t_marsh				= 15,
	Range_max			= 65000,
	H_min_t				= 0,
	Fi_start			= 0.5,
	Fi_rak				= 3.14152,
	Fi_excort			= 1,
	Fi_search			= 99.9,
	OmViz_max			= 99.9,
	X_back				= 0,
	Y_back				= 0,
	Z_back				= 0,
	Reflection			= 0.08,
	KillDistance		= 10,
	
	SeekerGen = 2,  -- Seeker generation

	manualWeaponFlag	= 1,

	-- might need to be regenerated again at some point but matches current fm
	
	MinLaunchDistData =
	{
		24,		10,
	
				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		100,	1000,	1300,	1650,	2200,	2750,	1650,	2150,	750,	800,	850,	
		200,	1400,	1450,	1900,	2350,	2850,	1300,	950,	1350,	1400,	1150,	
		300,	1300,	1600,	2050,	3900,	3000,	1050,	1150,	1300,	1300,	1450,	
		400,	1550,	1800,	2100,	2550,	3100,	1200,	1300,	1400,	1500,	1600,	
		500,	1800,	1900,	2200,	2700,	3250,	1400,	1450,	1550,	1650,	1750,	
		600,	1700,	2150,	2300,	2950,	3350,	1450,	1950,	1700,	1800,	1900,	
		700,	1700,	2050,	2400,	3050,	3450,	1550,	1700,	1850,	1950,	2050,	
		800,	1800,	2100,	2500,	3000,	3550,	1650,	1800,	1950,	2100,	2200,	
		900,	1850,	2200,	2600,	3100,	3650,	1750,	1900,	2050,	2200,	2350,	
		1000,	1900,	2250,	2700,	3150,	3750,	1850,	2000,	2200,	2300,	2450,	
		2000,	2350,	2800,	3300,	3850,	4450,	2550,	2800,	3050,	3250,	3450,	
		3000,	2800,	3100,	3700,	5300,	5000,	3100,	3400,	3700,	4100,	4200,	
		4000,	2600,	3300,	4000,	4700,	5900,	3800,	4000,	4300,	4600,	4900,	
		5000,	3000,	4000,	4250,	5500,	6500,	4000,	4500,	5500,	5500,	5750,	
		6000,	3000,	3500,	4500,	5500,	7000,	4500,	5000,	5500,	6000,	6500,	
		7000,	2500,	5000,	5000,	6000,	7000,	5500,	5500,	6000,	6500,	7000,	
		8000,	4500,	4500,	5000,	6500,	8000,	6500,	6000,	7000,	7500,	8000,	
		9000,	3500,	4500,	5500,	7000,	8000,	6000,	7500,	7500,	8500,	8500,	
		10000,	5000,	4000,	6000,	8500,	8500,	7500,	7500,	9000,	9500,	9500,	
		11000,	4000,	5000,	7500,	8000,	9000,	8000,	9500,	9000,	10000,	11000,	
		12000,	4500,	5000,	7500,	9000,	10500,	8500,	9500,	10000,	11000,	12000,	
		13000,	5000,	7500,	8000,	10500,	11000,	10000,	10500,	11500,	12500,	13000,	
		14000,	6000,	8500,	10500,	11000,	12500,	11000,	12000,	14000,	13500,	14500,	
		15000,	5000,	8000,	11000,	12000,	13500,	12000,	13000,	14000,	15000,	16000,	
	},	

	LaunchDistData =
	{
		24,		10,
	
				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		100,	58500,	62500,	66000,	70000,	73500,	75000,	78500,	82500,	86000,	89500,	
		200,	59000,	63000,	67000,	71000,	74500,	76000,	79500,	83000,	87000,	90500,	
		300,	60000,	64000,	68000,	71500,	75500,	77000,	80500,	84000,	88000,	91500,	
		400,	60500,	65000,	69000,	72500,	76500,	78000,	81500,	85000,	89000,	92500,	
		500,	61500,	65500,	69500,	73500,	77500,	78500,	82500,	86000,	90000,	94000,	
		600,	62500,	66500,	70500,	74500,	79000,	79500,	83500,	87000,	91000,	95000,	
		700,	63000,	67500,	71500,	75500,	80000,	80500,	84500,	88000,	92000,	96000,	
		800,	64000,	68000,	72500,	77000,	81000,	81500,	85500,	89000,	93000,	97000,	
		900,	65000,	69000,	73500,	78000,	82500,	82500,	86500,	90000,	94000,	98500,	
		1000,	65500,	70000,	74500,	79000,	83500,	83500,	87500,	91500,	95500,	99500,	
		2000,	75500,	80500,	86000,	91500,	97500,	95000,	99500,	104000,	108500,	113500,	
		3000,	87000,	92500,	98000,	103500,	108500,	108000,	112500,	117000,	122000,	126500,	
		4000,	97000,	102500,	108000,	114000,	120500,	119000,	124000,	129000,	134500,	139500,	
		5000,	106500,	112500,	119000,	125500,	133000,	131000,	136500,	142000,	148000,	150000,	
		6000,	116000,	123000,	130000,	138000,	146500,	143500,	150000,	150000,	150000,	150000,	
		7000,	126500,	134000,	142500,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	
		8000,	137500,	146000,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	
		9000,	149000,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	
		10000,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	
		11000,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	144500,	150000,	
		12000,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	
		13000,	150000,	150000,	150000,	150000,	150000,	148500,	150000,	150000,	150000,	150000,	
		14000,	150000,	150000,	150000,	149500,	150000,	150000,	150000,	150000,	150000,	150000,	
		15000,	150000,	150000,	148500,	150000,	150000,	150000,	150000,	150000,	150000,	150000,	
	},	

	controller = {
		boost_start = 0.2,
		march_start = 5.2,
	},

	boost = specialize_engine_parameters(
		predefined_engine("Aerojet_Mk27").boost,
		{ nozzle_position = {{ -2.5, -0.2, 0 }} }
	),

	march = specialize_engine_parameters(
		predefined_engine("Aerojet_Mk27").march,
		{ nozzle_position = {{ -2.5, -0.2, 0 }} }
	),

	-- boost = predefined_engine("Aerojet_Mk27").boost,

	-- march = predefined_engine("Aerojet_Mk27").march,

	fm = {	--placeholder params
		mass		= 620,
		caliber		= 0.343,
		cx_coeff	= {1,0.4,1.1,0.5,1.4},
		L			= 4.57,
		I			= 1 / 12 * 620 * 4.57 * 4.57,
		Ma			= 0.3,
		Mw			= 1.116,
		wind_sigma	= 0,
		wind_time	= 0,
		Sw			= 1.65,
		dCydA		= {0.07, 0.036},
		A			= 0.36,
		maxAoa		= 0.28,
		finsTau		= 0.1,

		Ma_x		= 0.001,
		Mw_x		= 0.08,
		I_x			= 50,
		model_roll  = math.rad(45),
	},

	radio_seeker = {
		FOV					= math.rad(90),
		op_time				= 300,
		keep_aim_time		= 0,
		pos_memory_time		= 0,
		sens_near_dist		= 50,
		sens_far_dist		= 90000,
		err_correct_time	= 1.0,
		err_val				= 0.001,
		calc_aim_dist		= 100000,
		blind_rad_val		= 0.3,
		blind_ctrl_dist		= 1000,
		aim_y_offset		= 0,
		min_sens_rad_val	= 0.0000005,
		filter_by_frequency	= true
	},

	-- radio_seeker = {
	-- 	FOV					= math.rad(90),
	-- 	op_time				= 300,
	-- 	keep_aim_time		= 0.1,
	-- 	pos_memory_time		= 0.1,
	-- 	sens_near_dist		= 50,
	-- 	sens_far_dist		= 90000,
	-- 	err_correct_time	= 1.0,
	-- 	err_val				= 0.001,
	-- 	calc_aim_dist		= 500000,
	-- 	blind_rad_val		= 10,
	-- 	blind_ctrl_dist		= 1000,
	-- 	aim_y_offset		= 0,
	-- 	min_sens_rad_val	= 0.0000005,
	-- 	filter_by_frequency	= true
	-- },

	fuze = {
		default_arm_delays			= { 10 },
		default_proximity_radius	= 10,
		is_neg_cls_rate_req			= true,
		is_proxy_tdd_always_enabled	= true,
	},

	autopilot = {
		delay			 = 0.0,
		K				 = 300,
		Kg				 = 5,
		Ki				 = 0,
		finsLimit		 = 0.2,
		useJumpByDefault = 0,
		J_Power_K		 = 0,
		J_Diff_K		 = 0,
		J_Int_K			 = 0,
		J_Angle_K		 =  math.rad(0),
		J_FinAngle_K	 =  math.rad(0),
		J_Angle_W		 = 0,
	},

	-- autopilot = {
	-- 	delay			 = 0.0,
	-- 	K				 = 300,
	-- 	Kg				 = 5,
	-- 	Ki				 = 0,
	-- 	finsLimit		 = 0.2,
	-- 	useJumpByDefault = 0,
	-- 	J_Power_K		 = 1.2,
	-- 	J_Diff_K		 = 0.4,
	-- 	J_Int_K			 = 0.0,
	-- 	J_Angle_K		 =	math.rad(12),
	-- 	J_FinAngle_K	 =  math.rad(18),
	-- 	J_Angle_W		 = 3.5,
	-- },

	start_helper = {
		delay				= 0,
		power				= 1,
		time				= 1,
		use_local_coord		= false,
		max_vel				= 300,
		max_height			= 0,
		vh_logic_or			= true,
	},

	simple_gyrostab_seeker = {
		omega_max	= math.rad(8)
	},

	target_mem = {
		memory = true,
		g_bias = true,
		bias_vector = {0,0,0.0008},
		wing_loading = 2900,
		accel_profile = {0.2, 5.2, 35.2, 2.6, 86, -0.1, 10.7, -40, -0.022}
	},

	warhead		= simple_warhead(97,343),

	smoke = {
		transparency	= 0.8,
		color			= {1, 0, 0}, --Red instead of White
		intensity		= 8,
		duration		= 500,
		flare			= true
	},

	shape_table_data = {{
		name		= "AGM_78B",
		file		= "HB_F-4E_ORD_AGM78",
		username	= _("AGM-78B"),
		index		= WSTYPE_PLACEHOLDER,
	}},
}

-- AGM_78B.target_mem.memory	= false	--To make the AGM-78 actually track
declare_weapon(AGM_78B)

AGM_78A = deepcopy(AGM_78B)

AGM_78A.target_mem.memory 	= false
AGM_78A.radio_seeker 		= deepcopy(AGM_45A.radio_seeker)

AGM_78A.name				= "AGM_78A"
AGM_78A.user_name			= _("AGM-78A Standard ARM")
AGM_78A.display_name_short	= "AGM-78A"
AGM_78A.model				= "HB_F-4E_ORD_AGM78"	--placeholder
AGM_78A.mass				= 615
AGM_78A.wsTypeOfWeapon[4]	= WSTYPE_PLACEHOLDER

AGM_78A.fm.mass = AGM_78A.mass
AGM_78A.shape_table_data[1].name = AGM_78A.name
AGM_78A.shape_table_data[1].model = AGM_78A.model
AGM_78A.shape_table_data[1].username = _("AGM-78A")
AGM_78A.shape_table_data[1].index = AGM_78A.wsTypeOfWeapon[4]

declare_weapon(AGM_78A)

declare_loadout({
	category		= CAT_MISSILES,
	CLSID			= "{AGM_78A}",
	attribute		= AGM_78A.wsTypeOfWeapon,
	wsTypeOfWeapon	= AGM_78A.wsTypeOfWeapon,
	Count			= 1,
	Cx_pil			= AGM_78A.Cx_pil/4096,	--placeholder
	Picture			= "aim54.png",	--placeholder
	displayName		= _("AGM-78A Standard ARM"),
	Weight			= AGM_78A.fm.mass,
	Weight_Empty	= 0,
	Elements		= {{ ShapeName = AGM_78A.model }},
	settings		= Get_RFGU_GUISettings_Preset("AGM_78A"),
})

declare_loadout({
	category		= CAT_MISSILES,
	CLSID			= "{AGM_78B}",
	attribute		= AGM_78B.wsTypeOfWeapon,
	wsTypeOfWeapon	= AGM_78B.wsTypeOfWeapon,
	Count			= 1,
	Cx_pil			= AGM_78B.Cx_pil/4096,	--placeholder
	Picture			= "aim54.png",	--placeholder
	displayName		= _("AGM-78B Standard ARM"),
	Weight			= AGM_78B.fm.mass,
	Weight_Empty	= 0,
	Elements		= {{ ShapeName = AGM_78B.model }},
	settings		= Get_RFGU_GUISettings_Preset("AGM_78B"),
})

-- Bare 45A
declare_loadout({
	category		= CAT_MISSILES,
	CLSID			= "{AGM_45A}",
	attribute		= AGM_45A.wsTypeOfWeapon,
	wsTypeOfWeapon	= AGM_45A.wsTypeOfWeapon,
	Count			= 1,
	Cx_pil			= AGM_45A.Cx_pil/4096,	--placeholder
	Picture			= "agm45.png",
	displayName		= _("AGM-45A Shrike ARM"),
	Weight			= AGM_45A.fm.mass,
	Weight_Empty	= 0,
	Elements		= {{ ShapeName = AGM_45A.model }},
	settings		= Get_RFGU_GUISettings_Preset("AGM_45")
})

-- Bare 45B
declare_loadout({
	category		= CAT_MISSILES,
	CLSID			= "{AGM_45B}",
	attribute		= AGM_45B.wsTypeOfWeapon,
	wsTypeOfWeapon	= AGM_45B.wsTypeOfWeapon,
	Count			= 1,
	Cx_pil			= AGM_45B.Cx_pil/4096,
	Picture			= "agm45.png",
	displayName		= _("AGM-45B Shrike ARM"),
	Weight			= AGM_45B.fm.mass,
	Weight_Empty	= 0,
	Elements		= {{ ShapeName = AGM_45B.model }},
	settings		= Get_RFGU_GUISettings_Preset("AGM_45")
})

-- 45A on LAU-118A
declare_loadout({
	category		= CAT_MISSILES,
	CLSID			= "{LAU118_AGM_45A}",
	attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= AGM_45A.wsTypeOfWeapon,
	Count			= 1,
	Cx_pil			= AGM_45A.Cx_pil/4096+0.001,
	Picture			= "agm45.png",
	displayName		= _("LAU-118A - AGM-45A Shrike ARM"),
	Weight			= 177 + 45.4, -- 45.4kg - lau-118 mass
	Weight_Empty	= 45.4,
	Elements		= {
		{ ShapeName = "lau-118a", IsAdapter = true },
		{ ShapeName = AGM_45A.model, Position = {0.091, -0.129, 0} },
	},
	settings		= Get_RFGU_GUISettings_Preset("AGM_45")
})

-- 45B on LAU-118A
declare_loadout({
	category		= CAT_MISSILES,
	CLSID			= "{3E6B632D-65EB-44D2-9501-1C2D04515405}",
	attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon	= AGM_45B.wsTypeOfWeapon,
	Count			= 1,
	Cx_pil			= AGM_45B.Cx_pil/4096+0.001,
	Picture			= "agm45.png",
	displayName		= _("LAU-118A - AGM-45B Shrike ARM"),
	Weight			= 177 + 45.4, -- 45.4kg - lau-118 mass
	Weight_Empty	= 45.4,
	Elements		= {
		{ ShapeName = "lau-118a", IsAdapter = true },
		{ ShapeName = AGM_45B.model, Position = {0.091, -0.129, 0} },
	},
	settings		= Get_RFGU_GUISettings_Preset("AGM_45")
})

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{AGM_122}",
	attribute		= {wsType_Weapon, wsType_Missile, wsType_AS_Missile, 68},
	Count 			= 1,
	Cx_pil			= 1,
	Picture			= "aim9m.png",
	displayName		= _("AGM-122 Sidearm - light ARM"),
	Weight			= 88,
	Elements  		= {{ShapeName = "agm-122"}},
})

declare_loadout({
	category 		= CAT_MISSILES,
	CLSID	 		= "{Kh-28}",
	attribute		= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,44},
	Count 			= 1,
	Cx_pil			= 5,
	Picture			= "kh22.png",
	displayName		= _('Kh-28 (AS-9 Kyle) - 720kg, ARM, Pas Rdr'),
	Weight			= 715,
	Elements  		= {{ShapeName = "X-28"}},
})

--copypasted from HB and fixed up
function LoadAGM45(swa, agm45, display_name, clsid)

	local swa_text = ""

	if swa then
		swa_text = "(Special Weapons Adapter) "
	end

	local result = {
		category = CAT_MISSILES,
		CLSID = clsid,
		attribute = {4, 4, 32, WSTYPE_PLACEHOLDER},
		Picture = "agm45.png",
		Count = 1,
		displayName = swa_text..display_name,
		wsTypeOfWeapon = agm45.wsTypeOfWeapon,
		Weight = agm45.mass + LAU_34_weight,
		Weight_Empty = LAU_34_weight,
		Cx_pil = agm45.Cx_pil / 4096.0 + LAU_34_drag,
		settings = Get_RFGU_GUISettings_Preset("AGM_45"),
		JettisonSubmunitionOnly = true,
		ejectVelocity	= 0,
		ejectPitchRate	= 0,

		Elements = {
			{
				Position	=	{0,0,0},
				ShapeName	=	"HB_F-4E_LAU-34",
				IsAdapter   =   true,
			},
			{
				Position	=	{0,	0, 0},
				ShapeName = agm45.model,
				connector_name = "AGM45_ATTACH",
			}
		},
	}

	return result
end

local AGM_45A_name = "AGM-45A Shrike ARM (LAU-34)"
declare_loadout(LoadAGM45(true, AGM_45A, AGM_45A_name,"{LAU_34_AGM_45A_SWA}"))
declare_loadout(LoadAGM45(false, AGM_45A, AGM_45A_name,"{LAU_34_AGM_45A}"))

local AGM_45B_name = "AGM-45B Shrike ARM (LAU-34)"
declare_loadout(LoadAGM45(true, AGM_45B, AGM_45B_name,"{LAU_34_AGM_45B_SWA}"))
declare_loadout(LoadAGM45(false, AGM_45B, AGM_45B_name,"{LAU_34_AGM_45B}"))

agm_78a_F4 = {
		category = CAT_MISSILES,
		CLSID = "{LAU_77_AGM_78A}",
		attribute = {4, 4, 32, WSTYPE_PLACEHOLDER},
		Picture = "agm45.png",
		Count = 1,
		displayName = _("AGM-78A Standard ARM"),
		wsTypeOfWeapon = AGM_78A.wsTypeOfWeapon,
		Weight = AGM_78A.mass + LAU_34_weight,
		Weight_Empty = LAU_34_weight,
		Cx_pil = AGM_78A.Cx_pil / 4096.0 + LAU_34_drag,
		settings = Get_RFGU_GUISettings_Preset("AGM_45"),	-- To test things
		-- settings = old_AGM_45_settings,	-- To test things
		JettisonSubmunitionOnly = true,

		Elements = {
			{
				Position	=	{0,0,0},
				ShapeName	=	"HB_F-4E_ORD_LAU_77",
				IsAdapter   =   true,
			},
			{
				Position	=	{0,	0, 0},
				ShapeName = AGM_78A.model,
				connector_name = "AGM_ATTACH",
			}
		},
	}

agm_78b_F4 = {
		category = CAT_MISSILES,
		CLSID = "{LAU_77_AGM_78B}",
		attribute = {4, 4, 32, WSTYPE_PLACEHOLDER},
		Picture = "agm45.png",
		Count = 1,
		displayName = _("AGM-78B Standard ARM"),
		wsTypeOfWeapon = AGM_78B.wsTypeOfWeapon,
		Weight = AGM_78B.mass + LAU_34_weight,
		Weight_Empty = LAU_34_weight,
		Cx_pil = AGM_78B.Cx_pil / 4096.0 + LAU_34_drag,
		settings = Get_RFGU_GUISettings_Preset("AGM_78B"),
		-- settings = Get_RFGU_GUISettings_Preset("AGM_45"),
		JettisonSubmunitionOnly = true,

		Elements = {
			{
				Position	=	{0,0,0},
				ShapeName	=	"HB_F-4E_ORD_LAU_77",
				IsAdapter   =   true,
			},
			{
				Position	=	{0,	0, 0},
				ShapeName = AGM_78B.model,
				connector_name = "AGM_ATTACH",
			}
		},
	}

declare_loadout(agm_78a_F4)
declare_loadout(agm_78b_F4)
